<?php

function thim_get_all_plugins_require( $plugins ) {
	return array(

		array(
			'name' => 'Widget Logic',
			'slug' => 'widget-logic',
		),

		array(
			'name' => 'Instagram Feed',
			'slug' => 'instagram-feed',
		),

		array(
			'name'     => 'SiteOrigin Page Builder',
			'slug'     => 'siteorigin-panels',
			'required' => true,
		),

		array(
			'name' => 'SiteOrigin Widgets Bundle',
			'slug' => 'so-widgets-bundle',
		),

		array(
			'name'        => 'Elementor Page Builder',
			'slug'        => 'elementor',
			'required'    => false,
			'description' => 'The most advanced frontend drag & drop page builder. Create high-end, pixel perfect websites at record speeds. Any theme, any page, any design.',
		),

		array(
			'name'        => 'Anywhere Elementor',
			'slug'        => 'anywhere-elementor',
			'required'    => false,
			'description' => 'Allows you to insert elementor pages and library templates anywhere using shortcodes.',
			'add-on'      => true,
		),

		array(
			'name' => 'Contact Form 7',
			'slug' => 'contact-form-7'
		),

		array(
			'name' => 'MailChimp for WordPress',
			'slug' => 'mailchimp-for-wp',
		),

		array(
			'name' => 'WooCommerce',
			'slug' => 'woocommerce',
		),

		array(
			'name'     => 'WP Hotel Booking',
			'slug'     => 'wp-hotel-booking',
			'required' => true,
		),

		array(
			'name'     => 'Revolution Slider',
			'slug'     => 'revslider',
			'version'  => '5.4.8.2',
			'premium'  => true,
			'required' => true,
			'icon'     => 'https://plugins.thimpress.com/downloads/images/revslider.png',
		),

		array(
			'name'    => 'Thim Testimonials',
			'slug'    => 'thim-testimonials',
			'version' => '1.3.1',
			'premium' => true,
			'icon'    => 'https://plugins.thimpress.com/downloads/images/thim-testimonials.png',
		),

		array(
			'name'   => 'WP Hotel Booking Authorize Sim',
			'slug'   => 'wp-hotel-booking-authorize-payment',
			'add-on' => true,
		),

		array(
			'name'   => 'WP Hotel Booking Block',
			'slug'   => 'wp-hotel-booking-block-room',
			'add-on' => true,
		),

		array(
			'name'   => 'WP Hotel Booking Coupon',
			'slug'   => 'wp-hotel-booking-coupon',
			'add-on' => true,
		),

		array(
			'name'   => 'WP Hotel Booking Report',
			'slug'   => 'wp-hotel-booking-report',
			'add-on' => true,
		),

		array(
			'name'   => 'WP Hotel Booking Stripe',
			'slug'   => 'wp-hotel-booking-stripe-payment',
			'add-on' => true,
		),

		array(
			'name'   => 'WP Hotel Booking WooCommerce',
			'slug'   => 'wp-hotel-booking-woocommerce',
			'add-on' => true,
		),

		array(
			'name'   => 'WP Hotel Booking WPML Support',
			'slug'   => 'wp-hotel-booking-wpml-support',
			'add-on' => true,
		),

		array(
			'name'   => 'WP Hotel Booking Room',
			'slug'   => 'wp-hotel-booking-booking-room',
			'add-on' => true,
		),
		array(
			'name'        => 'Sailing Demo Data',
			'slug'        => 'sailing-demo-data',
			'version'     => '2.0',
			'description' => 'Demo data for the theme Sailing.',
			'premium'     => true
		),
		array(
			'name'     => 'Classic Editor',
			'slug'     => 'classic-editor',
			'required' => false,
		),
	);
}

add_action( 'thim_core_get_all_plugins_require', 'thim_get_all_plugins_require' );

function thim_envato_item_id() {
	return '13321455';
}

add_filter( 'thim_envato_item_id', 'thim_envato_item_id' );

add_filter( 'thim_core_plugin_icon_install', 'thim_custom_plugin_icon', 10, 2 );
if ( !function_exists( 'thim_custom_plugin_icon' ) ) {
	function thim_custom_plugin_icon( $icon, $plugin ) {
		if ( $plugin->get_slug() == 'anywhere-elementor' ) {
			$icon = 'https://ps.w.org/' . $plugin->get_slug() . '/assets/icon-128x128.jpg';
		}

		return $icon;
	}
}